<?php

declare(strict_types=1);

/*
 * This file is part of the Ferienpass package.
 *
 * (c) Richard Henkenjohann <richard@ferienpass.online>
 *
 * For more information visit the project website <https://ferienpass.online>
 * or the documentation under <https://docs.ferienpass.online>.
 */

namespace Ferienpass\CoreBundle\ConsentManager;

use Ferienpass\CoreBundle\Entity\Consent;
use Ferienpass\CoreBundle\Entity\ConsentForm;
use Ferienpass\CoreBundle\Entity\Participant\ParticipantInterface;

class ConsentState
{
    public function __construct(private ConsentForm $consentForm, private ?Consent $signature = null, private ?ParticipantInterface $participant = null)
    {
    }

    public function getConsentForm(): ConsentForm
    {
        return $this->consentForm;
    }

    public function getParticipant(): ?ParticipantInterface
    {
        return $this->participant;
    }

    public function getConsentText(): ?string
    {
        return $this->consentForm->getText();
    }

    public function isSigned(): bool
    {
        return $this->signature && 1 === $this->signature->getDecision() && $this->signature->isValid() && !$this->signature->isRevoked();
    }

    public function hasSignature(): bool
    {
        return null !== $this->signature;
    }

    public function getSignature(): ?Consent
    {
        return $this->signature;
    }

    public function isAcknowledged(): bool
    {
        return null !== $this->signature;
    }

    public function isRevoked(): bool
    {
        return true === $this->signature?->isRevoked();
    }

    public function getCompulsory(): string
    {
        return $this->consentForm->getCompulsory();
    }

    public function isCompulsory(): bool
    {
        return 'compulsory' === $this->consentForm->getCompulsory();
    }
}
