<?php

declare(strict_types=1);

/*
 * This file is part of the Ferienpass package.
 *
 * (c) Richard Henkenjohann <richard@ferienpass.online>
 *
 * For more information visit the project website <https://ferienpass.online>
 * or the documentation under <https://docs.ferienpass.online>.
 */

namespace Ferienpass\CoreBundle\ApplicationSystem\Lotting;

use Ferienpass\CoreBundle\Entity\Participant\ParticipantInterface;

class Seats extends \ArrayObject
{
    public function contains(ParticipantInterface $participant): bool
    {
        /** @var Seat $seat */
        foreach ($this as $seat) {
            foreach ($seat->getAttendances() as $attendance) {
                if ($attendance->getParticipant() === $participant) {
                    return true;
                }
            }
        }

        return false;
    }
}
