<?php

declare(strict_types=1);

/*
 * This file is part of the Ferienpass package.
 *
 * (c) Richard Henkenjohann <richard@ferienpass.online>
 *
 * For more information visit the project website <https://ferienpass.online>
 * or the documentation under <https://docs.ferienpass.online>.
 */

namespace Ferienpass\CoreBundle\ApplicationSystem;

use Ferienpass\CoreBundle\Entity\Attendance;
use Ferienpass\CoreBundle\Entity\EditionTask;

interface ApplicationSystemInterface
{
    public const string LOT = 'lot';
    public const string FIRSTCOME = 'firstcome';

    public static function getType(): string;

    /**
     * Application-system suggested transition for new or moving attendances.
     * Returns null if no transition is suggested.
     */
    public function suggestTransition(Attendance $attendance): ?string;

    public function withTask(EditionTask $task): self;

    public function getTask(): ?EditionTask;
}
