<?php

namespace Symfony\Component\DependencyInjection\Loader\Configurator;

use Ferienpass\CoreBundle\ApplicationSystem\FirstComeApplicationSystem;
use Ferienpass\CoreBundle\ApplicationSystem\LotApplicationSystem;
use Ferienpass\CoreBundle\Controller\StorageFileController;
use Ferienpass\CoreBundle\Entity\User;
use Ferienpass\CoreBundle\Filesystem\PublicUri\StoragePublicUriProvider;
use Ferienpass\CoreBundle\Payments\Provider\NoOpPaymentProvider;
use Ferienpass\CoreBundle\Payments\Provider\PaymentProviderInterface;
use Ferienpass\CoreBundle\Security\ContaoBackendUser;
use Ferienpass\CoreBundle\Security\ContaoUserProvider;
use Ferienpass\CoreBundle\Security\UserChecker;
use Symfony\Component\Form\AbstractTypeExtension;
use Symfony\Component\Security\Core\Authorization\Voter\VoterInterface;

return function(ContainerConfigurator $container): void {
    $services = $container->services()
        ->defaults()
        ->autoconfigure()
        ->autowire()
        ->bind('$messagesLogger', service('monolog.logger.ferienpass_messages'))
        ->bind('$notificationsLogger', service('monolog.logger.ferienpass_notifications'))
    ;

    $services
        ->load('Ferienpass\\CoreBundle\\', '../src/')
        ->exclude([
            '../src/{DependencyInjection,Entity}',
            '../src/**/PdfExportConfig.php'
        ])
    ;

    // Tags autoconfigure
    $services
        ->instanceof(AbstractTypeExtension::class)
        ->tag('form.type_extension')
    ;
    $services
        ->instanceof(VoterInterface::class)
        ->tag('security.voter')
    ;

    $services->get(FirstComeApplicationSystem::class)
        ->tag('ferienpass.application_system')
    ;
    $services->get(LotApplicationSystem::class)
        ->tag('ferienpass.application_system')
    ;

    $services->get(UserChecker::class)
        ->tag('security.user_checker.contao_backend', ['priority' => 10])
        ->tag('security.user_checker.contao_frontend', ['priority' => 10])
        ->tag('security.user_checker.ferienpass_admin', ['priority' => 10])
        ->tag('security.user_checker.api', ['priority' => 10])
    ;

    $services->get(UserChecker\FrontendUserChecker::class)
        ->tag('security.user_checker.contao_frontend', ['priority' => 5])
    ;
    $services->get(UserChecker\AdminUserChecker::class)
        ->tag('security.user_checker.ferienpass_admin', ['priority' => 5])
    ;

    $services->set('ferienpass.security.contao_backend_user_provider', ContaoUserProvider::class)
        ->args([
            service('contao.framework'),
            ContaoBackendUser::class,
            service('doctrine'),
            User::class,
            'email'
        ])
    ;

    $services->set(StorageFileController::class)
        ->args([service_locator([
            'media' => service('contao.filesystem.virtual.media'),
            'attachments' => service('contao.filesystem.virtual.attachments'),
            'logos' => service('contao.filesystem.virtual.logos'),
            'export' => service('contao.filesystem.virtual.export'),
        ])]);

    $services->get(StoragePublicUriProvider::class)
        ->tag('contao.public_file_uri_provider')
    ;

    $services->alias(PaymentProviderInterface::class, NoOpPaymentProvider::class);

//    $services->set('ferienpass.security.contao_frontend_user_provider', ContaoUserProvider::class)
//        ->args([
//            service('contao.framework'),
//            ContaoFrontendUser::class,
//            service('doctrine'),
//            User::class,
//            'email'
//        ])
//    ;
};
