<?php

declare(strict_types=1);

/*
 * This file is part of the Ferienpass package.
 *
 * (c) Richard Henkenjohann <richard@ferienpass.online>
 *
 * For more information visit the project website <https://ferienpass.online>
 * or the documentation under <https://docs.ferienpass.online>.
 */

namespace Ferienpass\CmsBundle\Voter;

use Contao\CoreBundle\Security\ContaoCorePermissions;
use Symfony\Component\Security\Core\Authentication\Token\TokenInterface;
use Symfony\Component\Security\Core\Authorization\Voter\Voter;

class FormFieldsVoter extends Voter
{
    protected function supports(string $attribute, mixed $subject): bool
    {
        if (ContaoCorePermissions::USER_CAN_ACCESS_FIELD_TYPE !== $attribute) {
            return false;
        }

        return \in_array($subject, ['html', 'fieldsetStart', 'fieldsetStop', 'password', 'range', 'hidden'], true);
    }

    protected function voteOnAttribute(string $attribute, mixed $subject, TokenInterface $token, ?\Symfony\Component\Security\Core\Authorization\Voter\Vote $vote = null): bool
    {
        return false;
    }
}
