<?php

declare(strict_types=1);

/*
 * This file is part of the Ferienpass package.
 *
 * (c) Richard Henkenjohann <richard@ferienpass.online>
 *
 * For more information visit the project website <https://ferienpass.online>
 * or the documentation under <https://docs.ferienpass.online>.
 */

namespace Ferienpass\CmsBundle\Twig\Extension;

use Contao\CoreBundle\Csrf\ContaoCsrfTokenManager;
use Twig\Attribute\AsTwigFunction;

class RequestTokenExtension
{
    public function __construct(private readonly ContaoCsrfTokenManager $tokenManager)
    {
    }

    #[AsTwigFunction('contao_request_token')]
    public function requestToken(): string
    {
        return $this->tokenManager->getDefaultTokenValue();
    }
}
