<?php

declare(strict_types=1);

/*
 * This file is part of the Ferienpass package.
 *
 * (c) Richard Henkenjohann <richard@ferienpass.online>
 *
 * For more information visit the project website <https://ferienpass.online>
 * or the documentation under <https://docs.ferienpass.online>.
 */

namespace Ferienpass\CmsBundle\LiveComponent;

use Ferienpass\CmsBundle\Dto\AccessCodeDto;
use Ferienpass\CoreBundle\Repository\AccessCodeStrategyRepository;
use Symfony\UX\LiveComponent\Hydration\HydrationExtensionInterface;

class AccessCodeHydrationExtension implements HydrationExtensionInterface
{
    public function __construct(private readonly AccessCodeStrategyRepository $repository)
    {
    }

    public function supports(string $className): bool
    {
        return is_a($className, AccessCodeDto::class, true);
    }

    public function hydrate(mixed $value, string $className): ?object
    {
        $strategy = $this->repository->find($value['strategy']);

        return new AccessCodeDto($strategy, $value['code']);
    }

    public function dehydrate(object $object): mixed
    {
        /** @var AccessCodeDto $object */

        return [
            'strategy' => $object->getAccessCodeStrategy()->getId(),
            'code' => $object->getCode(),
        ];
    }
}
