<?php

declare(strict_types=1);

/*
 * This file is part of the Ferienpass package.
 *
 * (c) Richard Henkenjohann <richard@ferienpass.online>
 *
 * For more information visit the project website <https://ferienpass.online>
 * or the documentation under <https://docs.ferienpass.online>.
 */

namespace Ferienpass\CmsBundle\Form\CompoundType;

use Ferienpass\CoreBundle\Entity\PostalAddress;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\HttpFoundation\RequestStack;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\UX\LiveComponent\Form\Type\LiveCollectionType;

class PostalAddressesType extends AbstractType
{
    public function __construct(private readonly RequestStack $requestStack)
    {
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'allow_delete' => false,
            'delete_empty' => function (?PostalAddress $address = null): bool {
                if ('live_component_cms' === $this->requestStack->getCurrentRequest()?->attributes->get('_route')) {
                    return false;
                }

                return !$address?->getStreet() && !$address?->getPostalCode() && !$address?->getCity();
            },
            'label' => false,
            'entry_type' => PostalAddressType::class,
            'entry_options' => ['label' => false],
        ]);
    }

    public function getParent(): string
    {
        return LiveCollectionType::class;
    }
}
