<?php

declare(strict_types=1);

/*
 * This file is part of the Ferienpass package.
 *
 * (c) Richard Henkenjohann <richard@ferienpass.online>
 *
 * For more information visit the project website <https://ferienpass.online>
 * or the documentation under <https://docs.ferienpass.online>.
 */

namespace Ferienpass\CmsBundle\Form\CompoundType;

use Ferienpass\CoreBundle\Entity\Participant\ParticipantInterface;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\HttpFoundation\RequestStack;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\UX\LiveComponent\Form\Type\LiveCollectionType;

class ParticipantsType extends AbstractType
{
    public function __construct(private readonly RequestStack $requestStack)
    {
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'entry_type' => ParticipantType::class,
            'allow_add' => true,
            'allow_delete' => false,
            'delete_empty' => function (?ParticipantInterface $participant = null): bool {
                if ('live_component_cms' === $this->requestStack->getCurrentRequest()?->attributes->get('_route')) {
                    return false;
                }

                return '' === $participant->getName();
            },
            'label' => false,
            'entry_options' => ['label' => false],
        ]);
    }

    public function getParent(): string
    {
        return LiveCollectionType::class;
    }
}
