<?php

declare(strict_types=1);

/*
 * This file is part of the Ferienpass package.
 *
 * (c) Richard Henkenjohann <richard@ferienpass.online>
 *
 * For more information visit the project website <https://ferienpass.online>
 * or the documentation under <https://docs.ferienpass.online>.
 */

namespace Ferienpass\CmsBundle\DependencyInjection;

use Ferienpass\CmsBundle\EventListener\DataContainer\RegisterPageImageListener;
use Symfony\Component\AssetMapper\AssetMapperInterface;
use Symfony\Component\Config\FileLocator;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Extension\Extension;
use Symfony\Component\DependencyInjection\Extension\PrependExtensionInterface;
use Symfony\Component\DependencyInjection\Loader\PhpFileLoader;

final class FerienpassCmsExtension extends Extension implements PrependExtensionInterface
{
    public function load(array $configs, ContainerBuilder $container): void
    {
        $config = $this->processConfiguration(new Configuration(), $configs);

        $loader = new PhpFileLoader($container, new FileLocator(__DIR__.'/../../config'));
        $loader->load('services.php');

        if (false === $config['page_image']) {
            $container->removeDefinition(RegisterPageImageListener::class);
        }

        $container->setParameter('ferienpass_cms.welcome_steps', $config['welcome_steps']);
    }

    public function prepend(ContainerBuilder $container): void
    {
        $this->prependTwigBundle($container);
        $this->prependDoctrineBundle();

        $container->prependExtensionConfig('contao', [
            'localconfig' => [
                'licenseAccepted' => true,
                'enableSearch' => false,
                'disableCron' => true,
            ],
            'cron' => [
                'web_listener' => false,
            ],
        ]);

        $container->prependExtensionConfig('twig_component', [
            'defaults' => [
                'Ferienpass\CmsBundle\Components\\' => [
                    'template_directory' => '@Contao/components',
                    'name_prefix' => 'Cms',
                ],
            ],
        ]);

        if ($this->isAssetMapperAvailable($container)) {
            $container->prependExtensionConfig('framework', [
                'asset_mapper' => [
                    'paths' => [
                        __DIR__.'/../../assets/dist' => '@ferienpass/ux-cms',
                    ],
                ],
            ]);
        }
    }

    private function prependTwigBundle(ContainerBuilder $container): void
    {
        $container->prependExtensionConfig('twig', [
            'form_themes' => [
                '@FerienpassCms/form/custom_types.html.twig',
            ],
        ]);
    }

    private function prependDoctrineBundle(): void
    {
        //        $container->prependExtensionConfig('doctrine', [
        //            'orm' => [
        //                'dql' => [
        //                    'string_functions' => [
        //                        'DATE_FORMAT' => DateFormat::class,
        //                        'TIMESTAMPDIFF' => TimestampDiff::class,
        //                        'JSON_SEARCH' => JsonSearch::class,
        //                    ],
        //                ],
        //            ],
        //        ]);
    }

    private function isAssetMapperAvailable(ContainerBuilder $container): bool
    {
        if (!interface_exists(AssetMapperInterface::class)) {
            return false;
        }

        // check that FrameworkBundle 6.3 or higher is installed
        $bundlesMetadata = $container->getParameter('kernel.bundles_metadata');
        if (!isset($bundlesMetadata['FrameworkBundle'])) {
            return false;
        }

        return is_file($bundlesMetadata['FrameworkBundle']['path'].'/Resources/config/asset_mapper.php');
    }
}
