<?php

declare(strict_types=1);

/*
 * This file is part of the Ferienpass package.
 *
 * (c) Richard Henkenjohann <richard@ferienpass.online>
 *
 * For more information visit the project website <https://ferienpass.online>
 * or the documentation under <https://docs.ferienpass.online>.
 */

namespace Ferienpass\CmsBundle\DependencyInjection;

use Symfony\Component\Config\Definition\Builder\TreeBuilder;
use Symfony\Component\Config\Definition\ConfigurationInterface;

final class Configuration implements ConfigurationInterface
{
    public function getConfigTreeBuilder(): TreeBuilder
    {
        $treeBuilder = new TreeBuilder('ferienpass_cms');
        $treeBuilder->getRootNode()
            ->children()
                ->booleanNode('page_image')
                    ->defaultFalse()
                ->end()
                ->arrayNode('welcome_steps')
                    ->scalarPrototype()->end()
                    ->defaultValue(['willkommen', 'teilnehmer', 'anschrift'])
                ->end()
            ->end()
        ;

        return $treeBuilder;
    }
}
