<?php

declare(strict_types=1);

/*
 * This file is part of the Ferienpass package.
 *
 * (c) Richard Henkenjohann <richard@ferienpass.online>
 *
 * For more information visit the project website <https://ferienpass.online>
 * or the documentation under <https://docs.ferienpass.online>.
 */

namespace Ferienpass\CmsBundle\Controller\Fragment;

use Contao\CoreBundle\Filesystem\VirtualFilesystemInterface;
use Doctrine\Common\Collections\Collection;
use Ferienpass\CmsBundle\Controller\AbstractController;
use Ferienpass\CoreBundle\Entity\Offer\OfferInterface;
use Ferienpass\CoreBundle\Entity\OfferAttachment;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;

final class OfferDetailsController extends AbstractController
{
    public function __construct(private readonly VirtualFilesystemInterface $attachmentsStorage)
    {
    }

    public function __invoke(OfferInterface $offer, Request $request): Response
    {
        $this->tagResponse('offer.'.$offer->getId());

        return $this->render('@Contao/fragment/offer_details.html.twig', [
            'offer' => $offer,
            'attachments' => $this->getFilesystemItems($offer->getAttachments()),
        ]);
    }

    private function getFilesystemItems(Collection $attachments): array
    {
        $items = [];
        foreach ($attachments as $attachment) {
            /** @var OfferAttachment $attachment */
            $items[] = $this->attachmentsStorage->get($attachment->getAttachment()->getUuid());
        }

        return array_filter($items);
    }
}
