<?php

declare(strict_types=1);

/*
 * This file is part of the Ferienpass package.
 *
 * (c) Richard Henkenjohann <richard@ferienpass.online>
 *
 * For more information visit the project website <https://ferienpass.online>
 * or the documentation under <https://docs.ferienpass.online>.
 */

namespace Ferienpass\CmsBundle\Controller\Fragment;

use Contao\CoreBundle\Controller\AbstractController;
use Ferienpass\CoreBundle\Entity\User;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;

final class ConsentsController extends AbstractController
{
    public function __invoke(Request $request): Response
    {
        $user = $this->getUser();
        if (!($user instanceof User)) {
            return new Response('', Response::HTTP_NO_CONTENT);
        }

        return $this->render('@Contao/fragment/user_account/consents.html.twig');
    }
}
