<?php

declare(strict_types=1);

/*
 * This file is part of the Ferienpass package.
 *
 * (c) Richard Henkenjohann <richard@ferienpass.online>
 *
 * For more information visit the project website <https://ferienpass.online>
 * or the documentation under <https://docs.ferienpass.online>.
 */

namespace Ferienpass\CmsBundle\Controller\Fragment;

use Ferienpass\CmsBundle\View\ApplicationList;
use Ferienpass\CoreBundle\ApplicationSystem\ApplicationSystems;
use Ferienpass\CoreBundle\Entity\Attendance;
use Ferienpass\CoreBundle\Entity\User;
use Ferienpass\CoreBundle\Repository\AttendanceRepository;
use Ferienpass\CoreBundle\Repository\EditionTaskRepository;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;

class ApplicationListController extends AbstractController
{
    public function __construct(private readonly ApplicationSystems $applicationSystems, private readonly AttendanceRepository $attendances, private readonly EditionTaskRepository $periods)
    {
    }

    public function __invoke(Request $request): Response
    {
        $user = $this->getUser();
        if (!$user instanceof User) {
            return new Response('', Response::HTTP_NO_CONTENT);
        }

        /** @var array<int, Attendance> $result */
        $result = $this->attendances->createQueryBuilder('a')
            ->innerJoin('a.participant', 'p')
            ->innerJoin('a.offer', 'o')
            ->leftJoin('o.dates', 'd')
            ->orderBy('d.begin')
            ->where('p.user = :member')
            ->setParameter('member', $user->getId())
            ->getQuery()
            ->getResult()
        ;

        $applicationSystems = [];
        foreach ($result as $attendance) {
            $applicationSystems[$attendance->getId() ?? 0] = $this->applicationSystems->findApplicationSystem($attendance->getOffer());
        }

        $paymentPeriod = $this->periods->payment();

        return $this->render('@Contao/fragment/application_list.html.twig', [
            'editions' => ApplicationList::fromDatabaseResult($result)->getEditions(),
            'applicationSystems' => $applicationSystems,
            'paymentPeriod' => $paymentPeriod,
        ]);
    }
}
