<?php

declare(strict_types=1);

/*
 * This file is part of the Ferienpass package.
 *
 * (c) Richard Henkenjohann <richard@ferienpass.online>
 *
 * For more information visit the project website <https://ferienpass.online>
 * or the documentation under <https://docs.ferienpass.online>.
 */

namespace Ferienpass\CmsBundle\Components;

use Ferienpass\CoreBundle\Entity\Offer\OfferInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Session\Session;
use Symfony\UX\LiveComponent\Attribute\AsLiveComponent;
use Symfony\UX\LiveComponent\Attribute\LiveAction;
use Symfony\UX\LiveComponent\Attribute\LiveProp;
use Symfony\UX\LiveComponent\DefaultActionTrait;

#[AsLiveComponent(template: '@Contao/components/offer_list_item.html.twig', route: 'live_component_cms')]
class OfferListItem extends AbstractController
{
    use DefaultActionTrait;

    #[LiveProp]
    public OfferInterface $item;

    #[LiveAction]
    public function save(Session $session): void
    {
        $savedOffers = $session->get('saved_offers', []);

        if ($this->item->isSaved()) {
            $savedOffers = array_filter($savedOffers, fn ($v) => $v !== $this->item->getId());
        } else {
            $savedOffers[] = $this->item->getId();
        }

        $this->item->setSaved(!$this->item->isSaved());

        $session->set('saved_offers', $savedOffers);
    }
}
