<?php

declare(strict_types=1);

/*
 * This file is part of the Ferienpass package.
 *
 * (c) Richard Henkenjohann <richard@ferienpass.online>
 *
 * For more information visit the project website <https://ferienpass.online>
 * or the documentation under <https://docs.ferienpass.online>.
 */

namespace Ferienpass\CmsBundle\Components;

use Doctrine\ORM\EntityManagerInterface;
use Ferienpass\CoreBundle\Entity\User;
use Ferienpass\CoreBundle\Repository\ConsentRepository;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Bundle\SecurityBundle\Security;
use Symfony\UX\LiveComponent\Attribute\AsLiveComponent;
use Symfony\UX\LiveComponent\Attribute\LiveAction;
use Symfony\UX\LiveComponent\Attribute\LiveArg;
use Symfony\UX\LiveComponent\DefaultActionTrait;
use Symfony\UX\TwigComponent\Attribute\ExposeInTemplate;

#[AsLiveComponent(template: '@Contao/components/consents.html.twig', route: 'live_component_cms')]
class Consents extends AbstractController
{
    use DefaultActionTrait;

    public function __construct(private readonly ConsentRepository $consents, private readonly Security $security)
    {
    }

    #[ExposeInTemplate]
    public function consents(): array
    {
        $user = $this->getUser();
        if (!($user instanceof User)) {
            return [];
        }

        return $this->consents->findAllForUser($user);
    }

    #[LiveAction]
    public function toggle(#[LiveArg] int $id, EntityManagerInterface $entityManager): void
    {
        $consent = $this->consents->find($id);
        if (null === $consent) {
            return;
        }

        $this->denyAccessUnlessGranted('edit', $consent->getParticipant() ?? $consent->getUser());
        $consent->setDecision($consent->isRevoked() ? 1 : 0);

        $entityManager->flush();
    }
}
