<?php

declare(strict_types=1);

/*
 * This file is part of the Ferienpass package.
 *
 * (c) Richard Henkenjohann <richard@ferienpass.online>
 *
 * For more information visit the project website <https://ferienpass.online>
 * or the documentation under <https://docs.ferienpass.online>.
 */

namespace Ferienpass\CmsBundle\Application\ExclusionReasons;

use Contao\CoreBundle\OptIn\OptInInterface;
use Doctrine\DBAL\Connection;
use Ferienpass\CmsBundle\Application\ExclusionReasonEvent;
use Symfony\Component\EventDispatcher\Attribute\AsEventListener;
use Symfony\Component\Translation\TranslatableMessage;

#[AsEventListener(priority: 100)]
class UnconfirmedListener
{
    public function __construct(private readonly Connection $connection, private readonly OptInInterface $optIn)
    {
    }

    public function __invoke(ExclusionReasonEvent $event): void
    {
        $offer = $event->getOffer();
        $participant = $event->getParticipant();

        if ($participant->getUser() instanceof \Ferienpass\CoreBundle\Entity\User) {
            return;
        }

        $identifier = $this->connection->executeQuery("SELECT o.token FROM tl_opt_in_related r INNER JOIN tl_opt_in o ON o.id = r.pid WHERE r.relTable = 'Participant' AND r.relId = :participant_id AND o.email = :email", ['participant_id' => $participant->getId(), 'email' => $participant->getEmail()])->fetchOne();

        if (false === $identifier || !($optInToken = $this->optIn->find($identifier)) instanceof \Contao\CoreBundle\OptIn\OptInTokenInterface || !$optInToken->isConfirmed()) {
            throw new Unconfirmed($offer, $participant, new TranslatableMessage('ineligible.unconfirmedEmail', ['email' => $participant->getEmail()]));
        }
    }
}
