<?php

declare(strict_types=1);

/*
 * This file is part of the Ferienpass package.
 *
 * (c) Richard Henkenjohann <richard@ferienpass.online>
 *
 * For more information visit the project website <https://ferienpass.online>
 * or the documentation under <https://docs.ferienpass.online>.
 */

namespace Ferienpass\CmsBundle\Application\ExclusionReasons;

use Ferienpass\CmsBundle\Application\ExclusionReasonEvent;
use Symfony\Component\EventDispatcher\Attribute\AsEventListener;
use Symfony\Component\Translation\TranslatableMessage;

#[AsEventListener(priority: 90)]
class NoAccessCodeListener
{
    public function __invoke(ExclusionReasonEvent $event): void
    {
        $offer = $event->getOffer();
        $participant = $event->getParticipant();
        $applicationSystem = $event->getApplicationSystem();

        $accessCodes = $applicationSystem->getTask()?->getAccessCodeStrategy();
        if (!$accessCodes instanceof \Ferienpass\CoreBundle\Entity\AccessCodeStrategy || $accessCodes->isEnabledParticipant($participant)) {
            return;
        }

        throw new NoAccessCode($offer, $participant, new TranslatableMessage('ineligible.noAccessCode'));
    }
}
