<?php

declare(strict_types=1);

/*
 * This file is part of the Ferienpass package.
 *
 * (c) Richard Henkenjohann <richard@ferienpass.online>
 *
 * For more information visit the project website <https://ferienpass.online>
 * or the documentation under <https://docs.ferienpass.online>.
 */

namespace Ferienpass\CmsBundle\Application;

use Ferienpass\CoreBundle\Entity\Offer\OfferInterface;
use Ferienpass\CoreBundle\Entity\Participant\ParticipantInterface;
use Symfony\Component\Translation\TranslatableMessage;

class AbstractParticipantExclusionReason extends \Exception implements ParticipantExclusionReason
{
    public function __construct(private readonly OfferInterface $offer, private readonly ParticipantInterface $participant, private readonly TranslatableMessage $userMessage)
    {
        parent::__construct((string) $userMessage);
    }

    public function getReason(): string
    {
        $reflect = new \ReflectionClass($this);

        $name = $reflect->getShortName();
        $name = preg_replace('/Exception$/', '', $name);
        $name = preg_replace('/Reason$/', '', (string) $name);

        return strtolower((string) preg_replace('/(?<!^)[A-Z]/', '_$0', (string) $name));
    }

    public function getOffer(): OfferInterface
    {
        return $this->offer;
    }

    public function getParticipant(): ParticipantInterface
    {
        return $this->participant;
    }

    public function getUserMessage(): TranslatableMessage
    {
        return $this->userMessage;
    }
}
