'use strict';

import {Controller} from '@hotwired/stimulus';
// @ts-ignore
import {enter, leave} from "el-transition";
//import {Component, getComponent} from '@symfony/ux-live-component';

export default class extends Controller {
    static targets = ['disclosure'];
    static values = { filtersOpen: Boolean }

    declare readonly disclosureTarget: HTMLElement;
     declare filtersOpenValue: boolean;
    // declare readonly hasDynamicContentTarget: boolean;

    toggle(event: Event) {
        this.filtersOpenValue = !this.filtersOpenValue;
        this.filtersOpenValue ? this.disclosureTarget.classList.remove("hidden") : this.disclosureTarget.classList.add('hidden');
        (event.currentTarget as HTMLElement)?.setAttribute('aria-expanded', this.filtersOpenValue ? 'true' : 'false');
    }

    filtersOpenValueChanged() {
        this.filtersOpenValue ? enter(this.disclosureTarget) : leave(this.disclosureTarget)
    }
}
