<?php

declare(strict_types=1);

/*
 * This file is part of the Ferienpass package.
 *
 * (c) Richard Henkenjohann <richard@ferienpass.online>
 *
 * For more information visit the project website <https://ferienpass.online>
 * or the documentation under <https://docs.ferienpass.online>.
 */

namespace Ferienpass\CmsBundle\View;

use Ferienpass\CoreBundle\Entity\Attendance;
use Symfony\Component\DependencyInjection\Attribute\Exclude;

#[Exclude]
class ApplicationList
{
    private array $data;

    public static function fromDatabaseResult(array $attendances): static
    {
        $new = new static();
        $new->data = array_values(array_reduce($attendances, function ($carry, Attendance $value) {
            $carry[$value->getOffer()->getEdition()?->getId() ?? 0][] = $value;

            return $carry;
        }, []));

        return $new;
    }

    public function getEditions(): array
    {
        return array_map(function (array $attendances) {
            /** @var Attendance[] $attendances */
            $edition = $attendances[0]->getOffer()->getEdition();

            return [
                'name' => $edition->getName(),
                'attendances' => $attendances,
                'allPaid' => array_all($attendances, fn (Attendance $attendance) => $attendance->isPaid()),
                'archived' => new \DateTimeImmutable('-30 days') > $attendances[array_key_last($attendances)]->getOffer()->getDateEnd(),
                'payable' => $edition->getTasksOfType('payment')->count() && new \DateTimeImmutable() > $edition->getTasksOfType('payment')->first()->getPeriodBegin(),
            ];
        }, $this->data);
    }
}
