<?php

declare(strict_types=1);

/*
 * This file is part of the Ferienpass package.
 *
 * (c) Richard Henkenjohann <richard@ferienpass.online>
 *
 * For more information visit the project website <https://ferienpass.online>
 * or the documentation under <https://docs.ferienpass.online>.
 */

namespace Ferienpass\CmsBundle\Twig\Extension;

use Contao\StringUtil;
use Twig\Attribute\AsTwigFilter;

class StringUtilExtension
{
    #[AsTwigFilter('encodeEmail', isSafe: ['html'])]
    public function encodeEmail(?string $string): string
    {
        return StringUtil::encodeEmail((string) $string);
    }
}
