<?php

declare(strict_types=1);

/*
 * This file is part of the Ferienpass package.
 *
 * (c) Richard Henkenjohann <richard@ferienpass.online>
 *
 * For more information visit the project website <https://ferienpass.online>
 * or the documentation under <https://docs.ferienpass.online>.
 */

namespace Ferienpass\CmsBundle\LiveComponent;

use Ferienpass\CmsBundle\Dto\FriendCodeDto;
use Ferienpass\CoreBundle\Repository\OfferRepositoryInterface;
use Symfony\UX\LiveComponent\Hydration\HydrationExtensionInterface;

class FriendCodeHydrationExtension implements HydrationExtensionInterface
{
    public function __construct(private readonly OfferRepositoryInterface $repository)
    {
    }

    public function supports(string $className): bool
    {
        return is_a($className, FriendCodeDto::class, true);
    }

    public function hydrate(mixed $value, string $className): ?object
    {
        $offer = $this->repository->find($value['offer']);

        return new FriendCodeDto($offer, $value['code']);
    }

    public function dehydrate(object $object): mixed
    {
        /** @var FriendCodeDto $object */

        return [
            'offer' => $object->getOffer()->getId(),
            'code' => $object->getCode(),
        ];
    }
}
