<?php

declare(strict_types=1);

/*
 * This file is part of the Ferienpass package.
 *
 * (c) Richard Henkenjohann <richard@ferienpass.online>
 *
 * For more information visit the project website <https://ferienpass.online>
 * or the documentation under <https://docs.ferienpass.online>.
 */

namespace Ferienpass\CmsBundle\Filter\Type\Offer;

use Doctrine\ORM\QueryBuilder;
use Ferienpass\CoreBundle\Entity\Attendance;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\FormInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Translation\TranslatableMessage;
use Symfony\Contracts\Translation\TranslatableInterface;

class FreeSeatsType extends AbstractOfferFilterType
{
    public static function getName(): string
    {
        return 'sofortbuchung';
    }

    public function getParent(): string
    {
        return CheckboxType::class;
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        parent::configureOptions($resolver);

        $resolver->setDefaults([
            'label' => 'nur freie Plätze (Sofortbuchung)',
            'false_values' => ['', null],
        ]);
    }

    public function apply(QueryBuilder $qb, FormInterface $form): void
    {
        if ($form->isEmpty()) {
            return;
        }

        $qb
            ->andWhere($qb->expr()->orX('o.requiresApplication = 0', $qb->expr()->andX('o.requiresApplication = 1', 'o.onlineApplication = 1')))
            ->andWhere($qb->expr()->orX('o.applicationDeadline IS NULL', 'o.applicationDeadline >= CURRENT_TIMESTAMP()'))
            ->leftJoin('o.attendances', 'a')
            ->addSelect('sum(CASE WHEN a.status = :status_confirmed THEN 1 ELSE 0 END) AS HIDDEN countConfirmed')
            ->setParameter('status_confirmed', Attendance::STATUS_CONFIRMED)
            ->andHaving($qb->expr()->orX(
                'o.maxParticipants IS NULL',
                'o.maxParticipants > countConfirmed'
            ))
        ;
    }

    public function getHumanReadableValue(FormInterface $form): string|TranslatableInterface|null
    {
        return new TranslatableMessage('offerList.filter.free_seats');
    }
}
