<?php

declare(strict_types=1);

/*
 * This file is part of the Ferienpass package.
 *
 * (c) Richard Henkenjohann <richard@ferienpass.online>
 *
 * For more information visit the project website <https://ferienpass.online>
 * or the documentation under <https://docs.ferienpass.online>.
 */

namespace Ferienpass\CmsBundle\EventListener\Page;

use Contao\CoreBundle\DependencyInjection\Attribute\AsHook;
use Contao\PageModel;

#[AsHook('loadPageDetails')]
class PageImageDetailsListener
{
    public function __invoke(array $parentModels, PageModel $page): void
    {
        if (!$page->pageImage && \count($parentModels) > 0) {
            $rootPage = end($parentModels);

            $page->pageImage = $rootPage->pageImage;
        }
    }
}
