<?php

declare(strict_types=1);

/*
 * This file is part of the Ferienpass package.
 *
 * (c) Richard Henkenjohann <richard@ferienpass.online>
 *
 * For more information visit the project website <https://ferienpass.online>
 * or the documentation under <https://docs.ferienpass.online>.
 */

namespace Ferienpass\CmsBundle\EventListener\DataContainer;

use Contao\CoreBundle\DataContainer\PaletteManipulator;
use Contao\CoreBundle\DependencyInjection\Attribute\AsCallback;

#[AsCallback(table: 'tl_page', target: 'config.onload')]
class RegisterPageImageListener
{
    public function __invoke(): void
    {
        $paletteManipulator = PaletteManipulator::create()
            ->addLegend('image_legend', 'meta_legend', PaletteManipulator::POSITION_BEFORE, true)
            ->addField(['pageImage', 'pageImageOverwriteMeta'], 'image_legend', PaletteManipulator::POSITION_APPEND)
        ;

        foreach ($GLOBALS['TL_DCA']['tl_page']['palettes'] as $name => $palette) {
            if ('__selector__' === $name) {
                continue;
            }

            $paletteManipulator->applyToPalette($name, 'tl_page');
        }
    }
}
