<?php

declare(strict_types=1);

/*
 * This file is part of the Ferienpass package.
 *
 * (c) Richard Henkenjohann <richard@ferienpass.online>
 *
 * For more information visit the project website <https://ferienpass.online>
 * or the documentation under <https://docs.ferienpass.online>.
 */

namespace Ferienpass\CmsBundle\EventListener\DataContainer;

use Contao\CoreBundle\DataContainer\PaletteManipulator;
use Contao\CoreBundle\DependencyInjection\Attribute\AsCallback;
use Contao\DataContainer;

class ContentPaletteListener
{
    #[AsCallback(table: 'tl_content', target: 'config.onpalette')]
    public function content(string $palette, DataContainer $dc): string
    {
        $manipulator = PaletteManipulator::create();

        if (str_contains($palette, 'customTpl')) {
            $manipulator->removeField('customTpl', 'template_legend');
        }
        if (str_contains($palette, 'protected')) {
            $manipulator->removeField('protected', 'protected_legend');
        }
        if (str_contains($palette, 'cssID')) {
            $manipulator->removeField('cssID', 'expert_legend');
        }
        if (str_contains($palette, 'start')) {
            $manipulator->removeField('start', 'invisible_legend');
        }
        if (str_contains($palette, 'stop')) {
            $manipulator->removeField('stop', 'invisible_legend');
        }
        if (str_contains($palette, 'fullsize')) {
            $manipulator->removeField('fullsize');
        }
        if (str_contains($palette, 'overwriteMeta')) {
            $manipulator->removeField('overwriteMeta');
        }
        if (str_contains($palette, 'size')) {
            $manipulator->removeField('size');
        }

        return $manipulator->applyToString($palette);
    }

    #[AsCallback(table: 'tl_page', target: 'config.onpalette')]
    public function page(string $palette, DataContainer $dc): string
    {
        $manipulator = PaletteManipulator::create();

        if (str_contains($palette, 'start')) {
            $manipulator->removeField('start', 'publish_legend');
        }
        if (str_contains($palette, 'stop')) {
            $manipulator->removeField('stop', 'publish_legend');
        }

        return $manipulator->applyToString($palette);
    }

    #[AsCallback(table: 'tl_form', target: 'config.onpalette')]
    public function form(string $palette, DataContainer $dc): string
    {
        $manipulator = PaletteManipulator::create();

        if (str_contains($palette, 'jumpTo')) {
            $manipulator->removeField('jumpTo');
        }
        if (str_contains($palette, 'mailerTransport')) {
            $manipulator->removeField('mailerTransport');
        }

        return $manipulator->applyToString($palette);
    }

    #[AsCallback(table: 'tl_form_field', target: 'config.onpalette')]
    public function formField(string $palette, DataContainer $dc): string
    {
        $manipulator = PaletteManipulator::create();

        if (str_contains($palette, 'class')) {
            $manipulator->removeField('class');
        }
        if (str_contains($palette, 'accesskey')) {
            $manipulator->removeField('accesskey');
        }
        if (str_contains($palette, 'customTpl')) {
            $manipulator->removeField('customTpl');
        }
        if (str_contains($palette, 'minlength')) {
            $manipulator->removeField('minlength');
        }
        if (str_contains($palette, 'maxlength')) {
            $manipulator->removeField('maxlength');
        }

        return $manipulator->applyToString($palette);
    }

    #[AsCallback(table: 'tl_article', target: 'config.onpalette')]
    public function article(string $palette, DataContainer $dc): string
    {
        $manipulator = PaletteManipulator::create();

        if (str_contains($palette, 'start')) {
            $manipulator->removeField('start', 'publish_legend');
        }
        if (str_contains($palette, 'stop')) {
            $manipulator->removeField('stop', 'publish_legend');
        }

        return $manipulator->applyToString($palette);
    }
}
