<?php

declare(strict_types=1);

/*
 * This file is part of the Ferienpass package.
 *
 * (c) Richard Henkenjohann <richard@ferienpass.online>
 *
 * For more information visit the project website <https://ferienpass.online>
 * or the documentation under <https://docs.ferienpass.online>.
 */

namespace Ferienpass\CmsBundle\Dto;

use Ferienpass\CoreBundle\Entity\Offer\OfferInterface;

class FriendCodeDto
{
    public function __construct(private readonly OfferInterface $offer, private ?string $code = null)
    {
    }

    public function getOffer(): OfferInterface
    {
        return $this->offer;
    }

    public function getCode(): ?string
    {
        return $this->code;
    }

    public function setCode(?string $code): void
    {
        $this->code = $code;
    }
}
