<?php

declare(strict_types=1);

/*
 * This file is part of the Ferienpass package.
 *
 * (c) Richard Henkenjohann <richard@ferienpass.online>
 *
 * For more information visit the project website <https://ferienpass.online>
 * or the documentation under <https://docs.ferienpass.online>.
 */

namespace Ferienpass\CmsBundle\Dto;

use Ferienpass\CoreBundle\Entity\AccessCode;
use Ferienpass\CoreBundle\Entity\AccessCodeStrategy;

class AccessCodeDto
{
    public function __construct(private readonly AccessCodeStrategy $accessCodeStrategy, private ?string $code = null)
    {
    }

    public function getAccessCodeStrategy(): AccessCodeStrategy
    {
        return $this->accessCodeStrategy;
    }

    public function getCode(): ?string
    {
        return $this->code;
    }

    public function setCode(?string $code): void
    {
        $this->code = $code;
    }

    public function toEntity(): ?AccessCode
    {
        return $this->accessCodeStrategy->findCode($this->code);
    }
}
