<?php

declare(strict_types=1);

/*
 * This file is part of the Ferienpass package.
 *
 * (c) Richard Henkenjohann <richard@ferienpass.online>
 *
 * For more information visit the project website <https://ferienpass.online>
 * or the documentation under <https://docs.ferienpass.online>.
 */

namespace Ferienpass\CmsBundle\Controller\Page;

use Ferienpass\CmsBundle\Controller\AbstractController;
use Ferienpass\CmsBundle\Fragment\FragmentReference;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Attribute\Route;

#[Route('/passwort-vergessen')]
class LostPasswordController extends AbstractController
{
    #[Route('', name: 'cms_lost_password')]
    public function request(): Response
    {
        $this->initializeContaoFramework();

        return $this->createPageBuilder()
            ->addFragment('main', new FragmentReference('ferienpass.fragment.lost_password'))
            ->getResponse()
        ;
    }

    #[Route('/angefragt', name: 'cms_lost_password_requested')]
    public function requested(): Response
    {
        $this->initializeContaoFramework();

        return $this->createPageBuilder()
            ->addFragment('main', new FragmentReference('ferienpass.fragment.lost_password_requested'))
            ->getResponse()
        ;
    }

    #[Route('/neu', name: 'cms_lost_password_reset')]
    public function reset(): Response
    {
        $this->initializeContaoFramework();

        return $this->createPageBuilder()
            ->addFragment('main', new FragmentReference('ferienpass.fragment.lost_password_reset'))
            ->getResponse()
        ;
    }
}
