<?php

declare(strict_types=1);

/*
 * This file is part of the Ferienpass package.
 *
 * (c) Richard Henkenjohann <richard@ferienpass.online>
 *
 * For more information visit the project website <https://ferienpass.online>
 * or the documentation under <https://docs.ferienpass.online>.
 */

namespace Ferienpass\CmsBundle\Controller\Page;

use Contao\CoreBundle\Exception\PageNotFoundException;
use Ferienpass\CmsBundle\Controller\AbstractController;
use Ferienpass\CmsBundle\Fragment\FragmentReference;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\Session\Session;
use Symfony\Component\Routing\Attribute\Route;

#[Route('/merkliste')]
class FavoritesController extends AbstractController
{
    #[Route('', name: 'cms_favorites')]
    public function me(Session $session): Response
    {
        $this->initializeContaoFramework();

        $ids = $session->isStarted() ? $session->get('saved_offers', []) : [];

        return $this->createPageBuilder()
            ->addFragment('main', new FragmentReference('ferienpass.fragment.offer_list', ['ids' => $ids]))
            ->getResponse()
        ;
    }

    #[Route('/{link}', name: 'cms_favorites_link')]
    public function link(string $link): Response
    {
        $this->initializeContaoFramework();

        $link = explode(' ', $link);
        $ids = array_filter(filter_var($link, \FILTER_VALIDATE_INT, \FILTER_REQUIRE_ARRAY));

        if ([] === $ids) {
            throw new PageNotFoundException();
        }

        return $this->createPageBuilder()
            ->addFragment('main', new FragmentReference('ferienpass.fragment.offer_list', ['ids' => $ids]))
            ->getResponse()
        ;
    }
}
