<?php

declare(strict_types=1);

/*
 * This file is part of the Ferienpass package.
 *
 * (c) Richard Henkenjohann <richard@ferienpass.online>
 *
 * For more information visit the project website <https://ferienpass.online>
 * or the documentation under <https://docs.ferienpass.online>.
 */

namespace Ferienpass\CmsBundle\Controller\Fragment;

use Contao\CoreBundle\Controller\AbstractController;
use Ferienpass\CoreBundle\ApplicationSystem\ApplicationSystems;
use Ferienpass\CoreBundle\Repository\EditionRepository;
use Ferienpass\CoreBundle\Repository\ParticipantRepositoryInterface;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\Session\Session;
use Symfony\Component\HttpKernel\Attribute\MapQueryParameter;

class ApplicationsPrioritize extends AbstractController
{
    public function __construct(private readonly ParticipantRepositoryInterface $participants, private readonly EditionRepository $editions, private readonly ApplicationSystems $applicationSystems)
    {
    }

    public function __invoke(#[MapQueryParameter(name: 'id')] int $participantId, #[MapQueryParameter(name: 'edition')] int $editionId, Request $request, Session $session): Response
    {
        if (
            (null === $participant = $this->participants->find($participantId))
            || (null === $edition = $this->editions->find($editionId))
            || (!($applicationSystem = $this->applicationSystems->findApplicationSystem($edition)) instanceof \Ferienpass\CoreBundle\ApplicationSystem\ApplicationSystemInterface)
        ) {
            throw $this->createNotFoundException();
        }

        $this->denyAccessUnlessGranted('edit', $participant);

        return $this->render('@Contao/fragment/applications_prioritize.html.twig', [
            'edition' => $edition,
            'participant' => $participant,
            'applicationSystem' => $applicationSystem,
        ]);
    }
}
