<?php

declare(strict_types=1);

/*
 * This file is part of the Ferienpass package.
 *
 * (c) Richard Henkenjohann <richard@ferienpass.online>
 *
 * For more information visit the project website <https://ferienpass.online>
 * or the documentation under <https://docs.ferienpass.online>.
 */

namespace Ferienpass\CmsBundle\Application;

use Ferienpass\CoreBundle\ApplicationSystem\ApplicationSystemInterface;
use Ferienpass\CoreBundle\Entity\Offer\OfferInterface;
use Ferienpass\CoreBundle\Entity\Participant\ParticipantInterface;

class ExclusionReasonEvent
{
    public function __construct(private readonly OfferInterface $offer, private readonly ParticipantInterface $participant, private readonly ApplicationSystemInterface $applicationSystem)
    {
    }

    public function getOffer(): OfferInterface
    {
        return $this->offer;
    }

    public function getParticipant(): ParticipantInterface
    {
        return $this->participant;
    }

    public function getApplicationSystem(): ApplicationSystemInterface
    {
        return $this->applicationSystem;
    }
}
