<?php

declare(strict_types=1);

/*
 * This file is part of the Ferienpass package.
 *
 * (c) Richard Henkenjohann <richard@ferienpass.online>
 *
 * For more information visit the project website <https://ferienpass.online>
 * or the documentation under <https://docs.ferienpass.online>.
 */

use Contao\CoreBundle\DataContainer\PaletteManipulator;

foreach ($GLOBALS['TL_DCA']['tl_content']['palettes'] as $k => $palette) {
    if ('__selector__' === $k) {
        continue;
    }

    $GLOBALS['TL_DCA']['tl_content']['palettes'][$k] = str_replace(
        ',stop',
        ',stop,ferienpass_task_condition,ferienpass_task_condition_inverted',
        $GLOBALS['TL_DCA']['tl_content']['palettes'][$k]
    );
}

$GLOBALS['TL_DCA']['tl_content']['palettes']['countdown'] = '{type_legend},type;{text_legend},headline';
$GLOBALS['TL_DCA']['tl_content']['palettes']['greeting_with_picture'] =
    '{type_legend},type;{text_legend},headline,text;{image_legend},singleSRC';
$GLOBALS['TL_DCA']['tl_content']['palettes']['greeting'] = '{type_legend},type;{text_legend},headline,text;{persons_legend},persons';

$GLOBALS['TL_DCA']['tl_content']['palettes']['contact'] =
    '{type_legend},type,headline;{text_legend},text,address,email,phone,form';

$GLOBALS['TL_DCA']['tl_content']['palettes']['offers'] =
    '{type_legend},type,headline';

$GLOBALS['TL_DCA']['tl_content']['fields']['text']['eval']['tl_class'] = ltrim(($GLOBALS['TL_DCA']['tl_content']['fields']['text']['eval']['tl_class'] ?? '').' clr');

$GLOBALS['TL_DCA']['tl_content']['fields']['persons'] = [
    'inputType' => 'group',
    'palette' => ['name', 'description', 'singleSRC'],
    'fields' => [
        'name' => [
            'inputType' => 'text',
            'eval' => ['tl_class' => 'w50'],
        ],
        'description' => [
            'inputType' => 'text',
            'eval' => ['tl_class' => 'clr long'],
        ],
        '&singleSRC' => [
            'eval' => ['mandatory' => false],
        ],
    ],
    'min' => 1,
    'max' => 0,
    'sql' => [
        'type' => 'blob',
        'notnull' => false,
    ],
];

$GLOBALS['TL_DCA']['tl_content']['fields']['address'] = [
    'exclude' => true,
    'inputType' => 'textarea',
    'sql' => "varchar(255) NOT NULL default ''",
];

$GLOBALS['TL_DCA']['tl_content']['fields']['email'] = [
    'exclude' => true,
    'inputType' => 'text',
    'eval' => ['rgxp' => 'email'],
    'sql' => "varchar(255) NOT NULL default ''",
];

$GLOBALS['TL_DCA']['tl_content']['fields']['phone'] = [
    'exclude' => true,
    'inputType' => 'text',
    'eval' => ['rgxp' => 'phone'],
    'sql' => "varchar(255) NOT NULL default ''",
];

PaletteManipulator::create()
    ->removeField('headline', 'type_legend')
    ->removeField('embed', 'link_legend')
    ->removeField('titleText', 'link_legend')
    ->removeField('rel', 'link_legend')
    ->removeField('useImage', 'imglink_legend')
    ->addField('cvaSize', 'template_legend', PaletteManipulator::POSITION_APPEND)
    ->addField('cvaButtonStyle', 'template_legend', PaletteManipulator::POSITION_APPEND)
    ->addField('cvaPosition', 'template_legend', PaletteManipulator::POSITION_APPEND)
    ->applyToPalette('hyperlink', 'tl_content')
;

PaletteManipulator::create()
    ->addField('cvaSize', 'template_legend', PaletteManipulator::POSITION_APPEND)
    ->addField('cvaButtonStyle', 'template_legend', PaletteManipulator::POSITION_APPEND)
    ->addField('cvaPosition', 'template_legend', PaletteManipulator::POSITION_APPEND)
    ->applyToPalette('download', 'tl_content')
;

PaletteManipulator::create()
    ->addField('cvaSize', 'template_legend', PaletteManipulator::POSITION_APPEND)
    ->applyToPalette('text', 'tl_content')
;

PaletteManipulator::create()
    ->addField('cvaSize', 'template_legend', PaletteManipulator::POSITION_APPEND)
    ->applyToPalette('markdown', 'tl_content')
;

$GLOBALS['TL_DCA']['tl_content']['fields']['cvaSize'] = [
    'reference' => &$GLOBALS['TL_LANG']['tl_content']['cva']['size'],
    'exclude' => true,
    'inputType' => 'select',
    'options' => [
        'sm',
        'md',
        'lg',
        'xl',
    ],
    'eval' => [
        'includeBlankOption' => true,
        'mandatory' => false,
        'tl_class' => 'w50',
    ],
    'sql' => "varchar(32) NOT NULL default ''",
];

$GLOBALS['TL_DCA']['tl_content']['fields']['cvaPosition'] = [
    'reference' => &$GLOBALS['TL_LANG']['tl_content']['cva']['position'],
    'exclude' => true,
    'inputType' => 'select',
    'options' => [
        'left',
        'center',
        'right',
    ],
    'eval' => [
        'includeBlankOption' => true,
        'mandatory' => false,
        'tl_class' => 'w50',
    ],
    'sql' => "varchar(32) NOT NULL default ''",
];

$GLOBALS['TL_DCA']['tl_content']['fields']['cvaButtonStyle'] = [
    'reference' => &$GLOBALS['TL_LANG']['tl_content']['cva']['buttonStyle'],
    'exclude' => true,
    'inputType' => 'select',
    'options' => [
        'primary',
        'secondary',
    ],
    'eval' => [
        'includeBlankOption' => true,
        'mandatory' => false,
        'tl_class' => 'w50',
    ],
    'sql' => "varchar(32) NOT NULL default ''",
];

$GLOBALS['TL_DCA']['tl_content']['palettes']['pdf_proof'] =
    '{type_legend},type,headline;{list_legend},listitems;{template_legend:hide},customTpl;{protected_legend:hide},protected;{expert_legend:hide},guests,cssID;{invisible_legend:hide},invisible,start,stop';

$GLOBALS['TL_DCA']['tl_content']['fields']['ferienpass_task_condition'] = [
    'label' => &$GLOBALS['TL_LANG']['tl_content']['ferienpass_task_condition'],
    'reference' => &$GLOBALS['TL_LANG']['EditionTask']['type_options'],
    'exclude' => true,
    'inputType' => 'select',
    'options' => [
        'holiday',
        'host_editing_stage',
        'application_system',
        'allocation',
        'payment',
        'publish_lists',
        'show_offers',
    ],
    'eval' => [
        'tl_class' => 'clr w50',
        'includeBlankOption' => true,
    ],
    'sql' => "varchar(64) NOT NULL default ''",
];

$GLOBALS['TL_DCA']['tl_content']['fields']['ferienpass_task_condition_inverted'] = [
    'label' => &$GLOBALS['TL_LANG']['tl_content']['ferienpass_task_condition_inverted'],
    'exclude' => true,
    'inputType' => 'checkbox',
    'eval' => [
        'tl_class' => 'w50 m12',
    ],
    'sql' => "char(1) NOT NULL default ''",
];
