<?php

use Contao\CoreBundle\ContaoCoreBundle;
use Symfony\Component\Routing\Loader\Configurator\RoutingConfigurator;

return function (RoutingConfigurator $routes): void {
    $routes
        ->import('../src/Controller/Frontend/', type: 'attribute')
        ->defaults(['_scope' => ContaoCoreBundle::SCOPE_FRONTEND])
    ;
    $routes
        ->import('../src/Controller/Page/', type: 'attribute')
        ->defaults(['_scope' => ContaoCoreBundle::SCOPE_FRONTEND])
    ;
    $routes->import('../src/Components/', type: 'attribute');

    $routes->add('live_component_cms', '/_contao/_components/{_live_component}/{_live_action}')
        ->defaults(['_live_action' => 'get', '_scope' => 'frontend', '_token_check' => false]);
};
