<?php

namespace Symfony\Component\DependencyInjection\Loader\Configurator;

use Ferienpass\CoreBundle\ApplicationSystem\FirstComeApplicationSystem;
use Ferienpass\CoreBundle\ApplicationSystem\LotApplicationSystem;
use Ferienpass\CoreBundle\Controller\StorageFileController;
use Ferienpass\CoreBundle\Entity\User;
use Ferienpass\CoreBundle\Filesystem\PublicUri\StoragePublicUriProvider;
use Ferienpass\CoreBundle\Payments\Provider\NoOpPaymentProvider;
use Ferienpass\CoreBundle\Payments\Provider\PaymentProviderInterface;
use Ferienpass\CoreBundle\Security\ContaoBackendUser;
use Ferienpass\CoreBundle\Security\ContaoUserProvider;
use Ferienpass\CoreBundle\Security\UserChecker;
use Symfony\Component\Form\AbstractTypeExtension;
use Symfony\Component\Security\Core\Authorization\Voter\VoterInterface;

return function(ContainerConfigurator $container): void {
    $services = $container->services()
        ->defaults()
        ->autoconfigure()
        ->autowire()
    ;

    $services
        ->load('Ferienpass\\ApiBundle\\', '../src/')
        ->exclude([
            '../src/{DependencyInjection}',
        ])
    ;
};
