<?php

declare(strict_types=1);

namespace Ferienpass\AdminBundle\Tests\Breadcrumb;

use Ferienpass\AdminBundle\Breadcrumb\Breadcrumb;
use Knp\Menu\MenuFactory;
use PHPUnit\Framework\TestCase;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\RequestStack;

final class BreadcrumbTest extends TestCase
{
    public function testGenerateMarksCurrentItemBasedOnRequestUri(): void
    {
        $factory = new MenuFactory();

        $requestStack = new RequestStack();
        $requestStack->push(Request::create('/foo'));

        $sut = new Breadcrumb($factory, $requestStack);

        $menu = $sut->generate(
            ['Home', ['uri' => '/']],
            ['Current', ['uri' => '/foo']],
            ['NoUri'] // null URI should be considered current too
        );

        $children = iterator_to_array($menu->getChildren());
        $this->assertCount(3, $children);

        $this->assertFalse($children[0]->isCurrent(), '"/" should not be current when request is "/foo"');
        $this->assertTrue($children[1]->isCurrent(), 'Item with URI matching request should be marked current');
        $this->assertTrue($children[2]->isCurrent(), 'Item without URI should be marked current');
    }
}
