<?php

declare(strict_types=1);

/*
 * This file is part of the Ferienpass package.
 *
 * (c) Richard Henkenjohann <richard@ferienpass.online>
 *
 * For more information visit the project website <https://ferienpass.online>
 * or the documentation under <https://docs.ferienpass.online>.
 */

namespace Ferienpass\AdminBundle\Twig;

use Knp\Menu\ItemInterface;
use Knp\Menu\Twig\Helper;
use Twig\Attribute\AsTwigFunction;

class MenuExtension
{
    public function __construct(private readonly Helper $helper)
    {
    }

    #[AsTwigFunction('list_actions')]
    public function get($item, array $path = [], array $options = []): ItemInterface
    {
        return $this->helper->get('admin_list_actions', $path, ['item' => $item] + $options);
    }
}
