<?php

declare(strict_types=1);

/*
 * This file is part of the Ferienpass package.
 *
 * (c) Richard Henkenjohann <richard@ferienpass.online>
 *
 * For more information visit the project website <https://ferienpass.online>
 * or the documentation under <https://docs.ferienpass.online>.
 */

namespace Ferienpass\AdminBundle\MessageHandler;

use Ferienpass\AdminBundle\Message\PasswordLinkCreated;
use Ferienpass\AdminBundle\Message\ResetPassword as ResetPasswordCommand;
use Ferienpass\CoreBundle\Entity\User;
use Ferienpass\CoreBundle\Repository\UserRepository;
use Symfony\Component\Messenger\Attribute\AsMessageHandler;
use Symfony\Component\Messenger\MessageBusInterface;
use SymfonyCasts\Bundle\ResetPassword\Exception\ResetPasswordExceptionInterface;
use SymfonyCasts\Bundle\ResetPassword\ResetPasswordHelperInterface;

#[AsMessageHandler(bus: 'command.bus')]
class ResetPassword
{
    public function __construct(private readonly UserRepository $users, private readonly ResetPasswordHelperInterface $resetPasswordHelper, private readonly MessageBusInterface $eventBus)
    {
    }

    public function __invoke(ResetPasswordCommand $message): void
    {
        /** @var User $user */
        $user = $this->users->findOneBy(['email' => $message->getEmail()]);
        if (null === $user) {
            return;
        }

        try {
            $resetToken = $this->resetPasswordHelper->generateResetToken($user);
        } catch (ResetPasswordExceptionInterface) {
            return;
        }

        $this->eventBus->dispatch(new PasswordLinkCreated($user->getId(), $resetToken->getToken()));
    }
}
