<?php

declare(strict_types=1);

/*
 * This file is part of the Ferienpass package.
 *
 * (c) Richard Henkenjohann <richard@ferienpass.online>
 *
 * For more information visit the project website <https://ferienpass.online>
 * or the documentation under <https://docs.ferienpass.online>.
 */

namespace Ferienpass\AdminBundle\Message;

use Ferienpass\CoreBundle\Entity\User;
use Ferienpass\CoreBundle\Message\LoggableMessageInterface;

class PasswordLinkCreated implements LoggableMessageInterface
{
    public function __construct(private readonly int $userId, private readonly string $token)
    {
    }

    public function getUserId(): int
    {
        return $this->userId;
    }

    public function getToken(): string
    {
        return $this->token;
    }

    public function getRelated(): array
    {
        return [
            User::class => $this->userId,
        ];
    }
}
