<?php

declare(strict_types=1);

/*
 * This file is part of the Ferienpass package.
 *
 * (c) Richard Henkenjohann <richard@ferienpass.online>
 *
 * For more information visit the project website <https://ferienpass.online>
 * or the documentation under <https://docs.ferienpass.online>.
 */

namespace Ferienpass\AdminBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\PasswordType;
use Symfony\Component\Form\Extension\Core\Type\RepeatedType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Security\Core\Validator\Constraints\UserPassword;
use Symfony\Component\Validator\Constraints\Length;
use Symfony\Component\Validator\Constraints\NotBlank;

class UserChangePasswordType extends AbstractType
{
    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'label_format' => 'changePassword.%name%',
            'translation_domain' => 'admin',
        ]);
    }

    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('oldPassword', PasswordType::class, [
                'width' => '2/3',
                'attr' => ['autocomplete' => 'current-password'],
                'constraints' => [
                    new NotBlank(),
                    new UserPassword(['message' => 'Das alte Passwort ist nicht korrekt']),
                ],
            ])
            ->add('plainPassword', RepeatedType::class, [
                'type' => PasswordType::class,
                'options' => [
                    'attr' => [
                        'autocomplete' => 'new-password',
                    ],
                ],
                'first_options' => [
                    'constraints' => [
                        new NotBlank(message: 'Please enter a password'),
                        new Length(min: 6, max: 4096, minMessage: 'Your password should be at least {{ limit }} characters'),
                    ],
                    'label' => 'changePassword.newPassword',
                    'width' => '1/2',
                ],
                'second_options' => [
                    'label' => 'changePassword.repeatPassword',
                    'width' => '1/2',
                ],
                'invalid_message' => 'changePassword.passwordsDoNotMatch',
                'mapped' => false,
            ])
            ->add('submit', SubmitType::class)
        ;
    }
}
