<?php

declare(strict_types=1);

/*
 * This file is part of the Ferienpass package.
 *
 * (c) Richard Henkenjohann <richard@ferienpass.online>
 *
 * For more information visit the project website <https://ferienpass.online>
 * or the documentation under <https://docs.ferienpass.online>.
 */

namespace Ferienpass\AdminBundle\Form\TypeGuesser;

use Symfony\Component\DependencyInjection\Attribute\Exclude;
use Symfony\Component\Form\FormTypeGuesserInterface;
use Symfony\Component\Form\FormTypeInterface;
use Symfony\Component\Form\Guess\TypeGuess;
use Symfony\Component\Form\Guess\ValueGuess;

#[Exclude]
class TypeGuesser implements FormTypeGuesserInterface
{
    public function __construct(private readonly FormTypeInterface $type, private readonly ?string $class, private readonly ?string $property)
    {
    }

    public function guessType(string $class, string $property): ?TypeGuess
    {
        $classMatches = is_a($class, $this->class, true);
        $propertyMatches = $this->property === $property;

        if ($classMatches && $propertyMatches) {
            return new TypeGuess($this->type::class, [], TypeGuess::VERY_HIGH_CONFIDENCE);
        }

        if ($propertyMatches && null === $this->class) {
            return new TypeGuess($this->type::class, [], TypeGuess::HIGH_CONFIDENCE);
        }

        return null;
    }

    public function guessRequired(string $class, string $property): ?ValueGuess
    {
        return null;
    }

    public function guessMaxLength(string $class, string $property): ?ValueGuess
    {
        return null;
    }

    public function guessPattern(string $class, string $property): ?ValueGuess
    {
        return null;
    }
}
