<?php

declare(strict_types=1);

/*
 * This file is part of the Ferienpass package.
 *
 * (c) Richard Henkenjohann <richard@ferienpass.online>
 *
 * For more information visit the project website <https://ferienpass.online>
 * or the documentation under <https://docs.ferienpass.online>.
 */

namespace Ferienpass\AdminBundle\Form\Type;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Form\FormInterface;
use Symfony\Component\Form\FormView;
use Symfony\Component\OptionsResolver\OptionsResolver;

class MarkdownType extends AbstractType
{
    public function getParent(): string
    {
        return TextareaType::class;
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            // Allows passing JS options to the Stimulus controller
            'markdown_options' => [],
            'attr' => [
                'rows' => 10,
            ],
        ]);

        $resolver->setAllowedTypes('markdown_options', 'array');
    }

    public function buildView(FormView $view, FormInterface $form, array $options): void
    {
        $attr = $view->vars['attr'] ?? [];

        // attach Stimulus controller and pass options as JSON
        $controllers = [];
        if (isset($attr['data-controller'])) {
            $controllers[] = trim((string) $attr['data-controller']);
        }
        // Use namespaced identifier as configured in assets/controllers.json (package: app, controller: markdown)
        $controllers[] = 'ferienpass--admin-form-markdown';
        $attr['data-controller'] = trim(implode(' ', array_filter($controllers)));

        if (!empty($options['markdown_options'])) {
            $attr['data-ferienpass--admin-form-markdown-options-value'] = json_encode($options['markdown_options'], \JSON_THROW_ON_ERROR);
        }

        // ensure a sensible default class
        $classes = [];
        if (isset($attr['class'])) {
            $classes[] = trim((string) $attr['class']);
        }
        $classes[] = 'form-control';
        $attr['class'] = trim(implode(' ', array_filter($classes)));

        $view->vars['attr'] = $attr;
    }
}
