<?php

declare(strict_types=1);

/*
 * This file is part of the Ferienpass package.
 *
 * (c) Richard Henkenjohann <richard@ferienpass.online>
 *
 * For more information visit the project website <https://ferienpass.online>
 * or the documentation under <https://docs.ferienpass.online>.
 */

namespace Ferienpass\AdminBundle\Form;

use Ferienpass\CoreBundle\Entity\User;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\EmailType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Translation\TranslatableMessage;

class PersonalDataType extends AbstractType
{
    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => User::class,
            'required' => false,
            'label_format' => 'user.label.%name%',
            'translation_domain' => 'admin',
        ]);
    }

    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('firstname', options: [
                'width' => '1/2',
                'section' => 'personal',
            ])
            ->add('lastname', options: [
                'width' => '1/2',
                'section' => 'personal',
            ])
            ->add('email', EmailType::class, [
                'attr' => [
                    'placeholder' => 'email@beispiel.de',
                ],
                'width' => '2/3',
                'section' => 'personal',
            ])
            ->add('phone', options: [
                'width' => '1/2',
                'section' => 'personal',
            ])
            ->add('mobile', TextType::class, [
                'width' => '1/2',
                'section' => 'personal',
            ])
            ->add('publicFields', ChoiceType::class, [
                'choices' => [
                    'email',
                    'phone',
                    'mobile',
                ],
                'choice_label' => fn (string $choice): TranslatableMessage => new TranslatableMessage('user.label.'.$choice, domain: 'admin'),
                'expanded' => true,
                'multiple' => true,
                'section' => 'public',
            ])
            ->add('submit', SubmitType::class, [
                'label' => 'Daten speichern',
            ])
        ;
    }
}
