<?php

declare(strict_types=1);

/*
 * This file is part of the Ferienpass package.
 *
 * (c) Richard Henkenjohann <richard@ferienpass.online>
 *
 * For more information visit the project website <https://ferienpass.online>
 * or the documentation under <https://docs.ferienpass.online>.
 */

namespace Ferienpass\AdminBundle\Form;

use Doctrine\ORM\EntityRepository;
use Ferienpass\CoreBundle\Entity\Payment;
use Ferienpass\CoreBundle\Entity\PaymentItem;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class PaymentReverseType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('items', EntityType::class, [
                'class' => PaymentItem::class,
                'query_builder' => fn (EntityRepository $er) => $er
                    ->createQueryBuilder('paymentItem')
                    ->leftJoin('paymentItem.attendance', 'attendance')
                    ->leftJoin('attendance.offer', 'offer')
                    ->where('paymentItem.payment = :payment')
                    ->andWhere('paymentItem.type = :type')
                    ->setParameter('payment', $options['payment'])
                    ->setParameter('type', 'attendance'),
                'choice_label' => 'id',
                'expanded' => true,
                'multiple' => true,
            ])
            ->add('unpay', CheckboxType::class, [
                'required' => false,
                'label' => 'Anmeldungen als »unbezahlt« markieren',
                'data' => true,
            ])
            ->add('withdraw', CheckboxType::class, [
                'required' => false,
                'label' => 'Anmeldungen auf »abgemeldet« setzen',
            ])
        ;

        if ($options['payment']->getDebtor() ?? null) {
            $builder
               ->add('payout', ChoiceType::class, [
                   'choices' => [
                       'payout',
                       'balance',
                   ],
               ]);
        }

        $builder
            ->add('submit', SubmitType::class, [
                'label' => 'Ausgewählte stornieren',
            ])
        ;
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setRequired('payment');
        $resolver->setAllowedTypes('payment', Payment::class);
    }
}
