<?php

declare(strict_types=1);

/*
 * This file is part of the Ferienpass package.
 *
 * (c) Richard Henkenjohann <richard@ferienpass.online>
 *
 * For more information visit the project website <https://ferienpass.online>
 * or the documentation under <https://docs.ferienpass.online>.
 */

namespace Ferienpass\AdminBundle\Form\Offer;

use Ferienpass\AdminBundle\Form\AsOfferFormType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Validator\Constraints\File;
use Symfony\UX\Dropzone\Form\DropzoneType;

#[AsOfferFormType]
class UploadMedia extends AbstractType
{
    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'section' => 'media',
            'mapped' => false,
            'attr' => ['placeholder' => 'offers.dropzonePlaceholder'],
            'constraints' => [
                new File(maxSize: '6Mi', mimeTypes: [
                    'image/jpeg',
                    'image/png',
                ], mimeTypesMessage: 'Folgende Dateiformate sind erlaubt: JPG, PNG'),
            ],
        ]);
    }

    public function getParent(): string
    {
        return DropzoneType::class;
    }
}
