<?php

declare(strict_types=1);

/*
 * This file is part of the Ferienpass package.
 *
 * (c) Richard Henkenjohann <richard@ferienpass.online>
 *
 * For more information visit the project website <https://ferienpass.online>
 * or the documentation under <https://docs.ferienpass.online>.
 */

namespace Ferienpass\AdminBundle\Form\Offer;

use Ferienpass\AdminBundle\Form\AsOfferFormType;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\OptionsResolver\OptionsResolver;

#[AsOfferFormType]
class Edition extends AbstractType
{
    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'section' => 'default',
            'required' => true,
            'class' => \Ferienpass\CoreBundle\Entity\Edition::class,
            'choice_label' => 'name',
            'multiple' => false,
            'expanded' => false,
            'placeholder' => '-',
            'help' => 'offers.help.edition',
        ]);
    }

    public function getParent(): string
    {
        return EntityType::class;
    }
}
