<?php

declare(strict_types=1);

/*
 * This file is part of the Ferienpass package.
 *
 * (c) Richard Henkenjohann <richard@ferienpass.online>
 *
 * For more information visit the project website <https://ferienpass.online>
 * or the documentation under <https://docs.ferienpass.online>.
 */

namespace Ferienpass\AdminBundle\Form\Offer;

use Ferienpass\AdminBundle\Form\AsOfferFormType;
use Ferienpass\AdminBundle\Form\CompoundType\ContactMethodType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\HttpFoundation\RequestStack;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\UX\LiveComponent\Form\Type\LiveCollectionType;

#[AsOfferFormType]
class Contact extends AbstractType
{
    public function __construct(private readonly RequestStack $requestStack)
    {
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'entry_type' => ContactMethodType::class,
            'delete_empty' => function (?array $v = null): bool {
                if ('live_component_admin' === $this->requestStack->getCurrentRequest()?->attributes->get('_route')) {
                    return false;
                }

                return empty($v['name'] ?? '') && empty($v['email'] ?? '') && empty($v['phone'] ?? '');
            },
            'label' => false,
            'allow_add' => true,
            'allow_delete' => true,
            'by_reference' => false,
        ]);
    }

    public function getParent(): string
    {
        return LiveCollectionType::class;
    }
}
