<?php

declare(strict_types=1);

/*
 * This file is part of the Ferienpass package.
 *
 * (c) Richard Henkenjohann <richard@ferienpass.online>
 *
 * For more information visit the project website <https://ferienpass.online>
 * or the documentation under <https://docs.ferienpass.online>.
 */

namespace Ferienpass\AdminBundle\Form\Offer;

use Ferienpass\AdminBundle\Form\AsOfferFormType;
use Ferienpass\CoreBundle\Entity\OfferCategory;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\OptionsResolver\OptionsResolver;

#[AsOfferFormType]
class Categories extends AbstractType
{
    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'class' => OfferCategory::class,
            'multiple' => true,
            'expanded' => true,
            'choice_label' => 'name',
            'placeholder' => '-',
            'section' => 'default',
        ]);
    }

    public function getParent(): string
    {
        return EntityType::class;
    }
}
