<?php

declare(strict_types=1);

/*
 * This file is part of the Ferienpass package.
 *
 * (c) Richard Henkenjohann <richard@ferienpass.online>
 *
 * For more information visit the project website <https://ferienpass.online>
 * or the documentation under <https://docs.ferienpass.online>.
 */

namespace Ferienpass\AdminBundle\Form;

use Ferienpass\AdminBundle\Form\Event\SubmitEvent;
use Symfony\Component\EventDispatcher\EventDispatcherInterface;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Symfony\Component\Form\FormInterface;
use Symfony\Component\HttpFoundation\Request;

trait HandleFormTrait
{
    private function handleSubmit(FormInterface $form, EventDispatcherInterface $dispatcher, Request $request): void
    {
        foreach ($form->getConfig()->getType()->getTypeExtensions() as $typeExtension) {
            if ($typeExtension instanceof EventSubscriberInterface) {
                $dispatcher->addSubscriber($typeExtension);
            }
        }

        $dispatcher->dispatch(new SubmitEvent($form, $request));
    }
}
